define([
    'backbone',
    'Layout',
    'modules/new-appointment-request/views/direct/pac-team/modal',
], function(Backbone, Layout, PactTeamModalView) {
    'use strict';

    describe('Pact Team Modal', function() {
        var view;
        var $view;
        var layout;
        var content;

        beforeEach(function() {
            layout = new Layout();

            layout.render();
            content = layout.getRegion('content');

            $(content.el).append('<a class="test-link">A Link</a>');

            view = new PactTeamModalView({
                elAfterClose: layout.$el.find('.test-link'),
                model: new Backbone.Model(),
                team: new Backbone.Collection([
                    {
                        possiblePrimary: '',
                        staffName: 'One',
                    },
                    {
                        possiblePrimary: '',
                        staffName: 'Two',
                    },
                ]),
                primaryProviderList: 'V. A., M. D., D. C.',
            });
            view.openPopup();
            $view = view.$el;
        });

        afterEach(function() {
            view.closePopup();
        });

        it('shows the facility name in the heading', function() {
            expect($view.find('.ui-title').text()).toEqual('PACT Members');
        });

        it('shows the primary care providers and team list', function() {
            expect($view.find('.pact-team-primary-care-providers-label').text()).toEqual('Primary Care Providers:');
            expect($view.find('.pact-team-primary-care-providers-label + .field-value').text()).toEqual('V. A., M. D., D. C.');

            expect($view.find('.pact-team-list-label').text()).toEqual('Team List:');
            expect($view.find('.pact-team-list-label + .field-value').text()).toEqual('One; Two');
        });

        it('has a Close button', function() {
            expect($view.find('#pact-team-return-btn.return-btn').text()).toEqual('Close');
        });
    });
}
);
